<?php

require_once 'method.php';

function returnempty($m)
{
    return '';
}


function repi($a)
{
    return 'kl456kli>' . $a[2] . 'kl456kl/i>';
}
function repu($a)
{
    return 'kl456klu>' . $a[2] . 'kl456kl/u>';
}
function repa($a)
{
    return 'kl456kla href="tg://user?id=' . $a[3] . '">' . $a[4] . 'kl456kl/a>';
}
function repa_($a)
{
    return 'kl456kla href="' . $a[2] . '.' . $a[3] . '">' . $a[4] . 'kl456kl/a>';
}
function wwrr($a)
{
    return $a[1];
}
function wwrr1($a)
{
    $d = (isset($a[2])) ? $a[2] : null;
    return 'WORD_BY_WORD' . $d;
}



function _remove_empty_internal($value)
{
    return !empty($value);
}


function format_parsemode($text = null)
{
    if ($text) {
        $rrep = '/(\<\s*b\s*>)(.+?)(\<\s*\/b\s*>)/sm';
        $blockquote = '/(\<\s*blockquote\s*>)(.+?)(\<\s*\/blockquote\s*>)/sm';
        $strikethrough = '/(\<\s*s\s*>)(.+?)(\<\s*\/s\s*>)/sm';
        $rrepcode = '/(\<\s*code\s*>)(.+?)(\<\s*\/code\s*>)/sm';
        $rrep_spoiler = '/(\<\s*span\s*>)(.+?)(\<\s*\/span\s*>)/sm';
        $rrep_strikethrough = '/(\<\s*del\s*>)(.+?)(\<\s*\/del\s*>)/sm';
        $rrepi = '/(\<\s*i\s*>)(.+?)(\<\s*\/i\s*>)/sm';
        $rrepu = '/(\<\s*u\s*>)(.+?)(\<\s*\/u\s*>)/sm';
        $rrepa = '/(\<\s*a\s*href\s*\=\s*)\"?(tg\s*\:\/\/user\?id\s*\=)([0-9]{7,64})\"?\s*\>\s*(.+?)(\<\s*\/a\s*\>)/usm';
        $rrepa_ = '/(\<\s*a\s*href\s*\=\s*)\"?(.+?)\.(.+?)\"?\s*\>\s*(.+?)(\<\s*\/a\s*\>)/usm';
        $wwrr = '/^(.+)\s+(WORD_BY_WORD){1}([SH]){0,1}\s*$/sm';
        $wwrr1 = '/(\_WORDBYWORD_){1}([SH]){0,1}/sm';
        $patterns = [
            $blockquote => function ($a) {
                return 'kl456klblockquote>' . $a[2] . 'kl456kl/blockquote>';
            },
             $rrep => function ($a) {
                return 'kl456klb>' . $a[2] . 'kl456kl/b>';
            },
            $strikethrough => function ($a) {
                return 'kl456kls>' . $a[2] . 'kl456kl/s>';
            },
            $rrepcode => function ($a) {
                return 'kl456klcode>' . $a[2] . 'kl456kl/code>';
            },
            $rrep_spoiler => function ($a) {
                return 'kl456kltg-spoiler>' . $a[2] . 'kl456kl/tg-spoiler>';
            },
            $rrep_strikethrough => function ($a) {
                return 'kl456kldel>' . $a[2] . 'kl456kl/del>';
            },
            $rrepi => 'repi',
            $rrepu => 'repu',
            $rrepa => 'repa',
            $rrepa_ => 'repa_',
            $wwrr => 'wwrr',
            $wwrr1 => 'wwrr1',

        ];

        return preg_replace_callback_array($patterns, $text);
    }
}

function replace_htmltag($text = null)
{
    if ($text) {
        $text = str_replace('&', '&amp;', $text);
        //   $text=str_replace('>','&gt;',$text);
        $text = str_replace('<', '&lt;', $text);
        $text = str_replace('kl456kl', '<', $text);
    }
    return $text;
}

class Telegram
{

    use method;

    private $token;
    private $api;

    public $bots;
    public $language;
    public $array_time;
    public $signature;
    public $timezone;

    public  $is_admin = false;
    public  $is_admin_gp = false;
    public  $global_text;
    public  $delete_content_time;
    public  $submit_for_delete_message=[];
    public  $no_replacetag;
    public  $no_format;
    public  $no_entities=false;
    public  $not_keyboard;
    public  $plus_keyboard='';
    public  $typepage;
    public  $chat_id;
    public  $user_id;
    public  $message_id;
    public  $disable_web_page_preview;
    public  $is_keyword=null;
    public  $variables_text=[];
    public  $url_decode=true;
    public  $no_send_message=false;
    public  $Lab_mode=false;
    private $add_inline_key =[];
    private $rand_unique_number =[];
    private $current_chat_send='';
    private $chat_id_changed='';
    private $attach_media_to_message = [];
    public $close_db=0;
    public $exception_array=[];
    
    
    
    public $getme;
    public $bot_id;
    public $bot_username;
    public $bot_firstname;
    public $bot_can_join_groups;
    public $bot_supports_inline_queries;
    public $bot_number;
    public $table_name_users_list;

    public $m_message_id;
    public $m_message_id_2;
    public $m_message_ids=[];
    public $m_userid;
    public $m_is_bot;
    public $m_text;
    public $m_type;
    public $m_chat_idl;
    public $m_chat_id;
    public $m_first_name;
    public $m_username;
    public $m_date;
    public $m_title;
    public $send_ok;

    public $leaveChat = [];
    public $pin_message_id = [];
    public $destruct =[];
    
    function __construct(string$token, array $bots = [])
    {

        $this->token = $token;
        $this->api = 'https://api.telegram.org/bot' . $token . '/';

        if ($bots) {
            $this->bots($bots);
        } else {
            ($this->getme !== true) ? $this->getme() : null;
        }
    }

    function __destruct()
    {
        
        if($this->close_db) {
            unset($GLOBALS['conn']);
        }
    }

    function api($method, $content, $non = null)
    {

        $url = $this->api . $method . '?' . $content;
        
        @$f = file_get_contents($url);
        if ($f) {
            $this->send_ok = 'send_ok';
            $arraymessage = json_decode($f, true);
            return $f;
        } else {
            $this->send_ok = '';
        }
    }

    function bots($bots)
    {
        if ($bots === true) {
            $bots = run_sql("SELECT * FROM `bots` WHERE `bot_id`='" . $this->bot_id . "' AND `deleted`!=1 LIMIT 1");
        }
        if ($bots) {
            $this->bots = $bots;
            $this -> table_name_users_list = $bots[0]['table_name_users_list'];
            $bot = $bots[0];
            $this->bot_id = $bot['bot_id'];
            $this->bot_number = $bot['bot_number'];
            $this->bot_username = $bot['user_name'];
            $this->language = $bot['lan'];
            $this->signature = $this->decode_json($bot['signature']);
            $datetime = date("l j F Y H:i");
                $hours = date("H:i");
                $date = date("l j F Y ");
                $dayn = date('l');
                $dayc = date('d');
                $MONTHn = date('F');
                $MONTHc = date('n');
                $year=date('Y');
            $this->array_time = [$datetime, $hours, $date, $dayn, $MONTHn,$dayc,$MONTHc,$year];
        }
        return $bots;
    }
    #getme
    function getme($par = null)
    {
        $url = $this->api . "getMe";
        $f = file_get_contents($url);
        if ($f) {
            $ff = json_decode($f, true);
            $this->bot_id = $ff['result']['id'];
            $this->bot_firstname = $ff['result']['first_name'];
            $this->bot_username = $ff['result']['username'];
            $this->bot_can_join_groups = $ff['result']['can_join_groups'];
            $this->bot_supports_inline_queries = $ff['result']['supports_inline_queries'];
            $this->getme = true;
        }
    }
    function bot_firstname()
    {
        $url = $this->api . "getMe";
        $f = file_get_contents($url);
        if ($f) {
            $ff = json_decode($f, true);
            return $ff['result']['first_name'];
        }
    }
    function global_text($text = null)
    {
        $this->global_text = $text;
        return $text;
    }
    function is_admin($is_admin = false)
    {
        $this->is_admin = $is_admin;
        return $is_admin;
    }
    function is_keyword($is_keyword=null)
    {
        $this->is_keyword = $is_keyword;
        return $is_keyword;
    }
    function is_admin_gp($is_admin_gp = false)
    {
        $this->is_admin_gp = $is_admin_gp;
        return $is_admin_gp;
    }
    function signature($signature = null)
    {
        $this->signature = $signature;
        return $signature;
    }
    function destruct(array $destruct)
    {
        return array_push($this->destruct,$destruct);
    }
    function exception_array(array $exception_array)
    {
        array_merge($this->exception_array,$exception_array);
    }
    function language($language = null)
    {
        $this->language = $language;
        return $language;
    }
    function bot_number($bot_number = null)
    {
        $this->bot_number = $bot_number;
        return $bot_number;
    }
    function delete_content_time($delete_content_time = null)
    {
        $this->delete_content_time = $delete_content_time;
    }
    function variables_text($value)
    {
        if($value) {
            array_push($this->variables_text,$value);
        }
        return $value;
    }
    function no_replacetag($no_replacetag = false)
    {
        $this->no_replacetag = $no_replacetag;
        return $no_replacetag;
    }
    function no_format($no_format = false)
    {
        $this->no_format = $no_format;
        return $no_format;
    }
    function not_keyboard($not_keyboard = false)
    {
        $this->not_keyboard = $not_keyboard;
        return $not_keyboard;
    }
    function typepage($typepage = null)
    {
        $this->typepage = $typepage;
        return $typepage;
    }
    function chat_id($chat_id = null)
    {
        $this->chat_id = $chat_id;
        return $chat_id;
    }
    function disable_web_page_preview($disable_web_page_preview = null)
    {
        $this->disable_web_page_preview = $disable_web_page_preview;
        return $disable_web_page_preview;
    }
    function user_id($user_id = null)
    {
        $this->user_id = $user_id;
        return $user_id;
    }
    function Lab_mode($Lab_mode = null)
    {
        $this->Lab_mode = $Lab_mode;
        return $Lab_mode;
    }
    function no_send_message($value = false)
    {
        $this -> no_send_message = $value;
        return $value;
    }
    function message_id($message_id = null)
    {
        $this->message_id = $message_id;
        return $message_id;
    }
    function timezone($timezone = null)
    {
        $timezone=($timezone===true)?$this->bots[0]['timezone']:$timezone;
        if ($timezone) {
            date_default_timezone_set($timezone);
            $this->timezone = $timezone;
            return $timezone;
        }
    }

    function sendmessage($chat_id, $text, $reply_markup = null, $force_reply = null, $reply_to_message_id = null, $disable_web_page_preview = null, $disable_notification = null)
    {
        $text = $this->replace_define($text, $chat_id);
        $text = replace_htmltag($text);
        $this -> current_chat_send = $chat_id;
        if($this-> chat_id_changed) {
            $chat_id=$this-> chat_id_changed;
            $this-> chat_id_changed=null;
        }
        $w = null;
        $disable_notificationn = ($disable_notification) ? '&disable_notification=' . $disable_notification : null;
        $disable_web_page_preview=($disable_web_page_preview || $this->disable_web_page_preview)?true:false;
        $d_web_page = ($disable_web_page_preview) ? '&disable_web_page_preview=' . $disable_web_page_preview : null;
        $reply_to_message = (isset($reply_to_message_id)) ? "&reply_to_message_id=$reply_to_message_id" : null;
        $mark = ['force_reply' => true];
        $jsl = '&reply_markup=' . json_encode($mark);
        $forcereply = ($force_reply) ? $jsl : null;

        if (!$text) {
            return false;
        }
        if (isset($reply_markup)) {
            if (is_int($reply_markup)) {
                $reply_markup1 = '&reply_to_message_id=' . $reply_markup;
                $w = $this->api('sendMessage', 'chat_id=' . $chat_id . '&text=' . urlencode($text) . $reply_markup1 . $forcereply . '&parse_mode=HTML' . $d_web_page . $disable_notificationn);
            } elseif ($reply_markup == 'force_reply') {

                $w = $this->api('sendMessage', 'chat_id=' . $chat_id . '&text=' . urlencode($text) . $jsl . $reply_to_message . '&parse_mode=HTML' . $d_web_page);
            } else {
                if($this->add_inline_key){
                    $reply_markup=substr($reply_markup,0,-2).urlencode(','.implode(',',$this->add_inline_key)). ']}';
                    $this->add_inline_key=[];
                }
                $w = $this->api('sendMessage', 'chat_id=' . $chat_id . '&text=' . urlencode($text) . $forcereply . $reply_markup . $reply_to_message . '&parse_mode=HTML' . $d_web_page);
            }
        } else {
            if($this->add_inline_key){
                $reply_markup=$this->reply_markup(implode(',',$this->add_inline_key),'i');
                $this->add_inline_key=[];
            }
            $w =  $this->api('sendMessage', 'chat_id=' . $chat_id . '&text=' . urlencode($text) . $forcereply .$reply_markup. $reply_to_message . '&parse_mode=HTML' . $d_web_page);
        }

        if (isset($w)) {
            $result = json_decode($w, true);

            $this->m_message_id = $result['result']['message_id'];
            $this->m_message_ids['sendmessage']=$this->m_message_id;
            $this->m_message_id_2 = $result['result']['message_id'];
            $this->m_userid = $result['result']['from']['id'];
            $this->m_is_bot = $result['result']['from']['is_bot'];
            $this->m_text = $result['result']['text'];
            $this->m_type = $result['result']['chat']['type'];
            $this->m_chat_id = $result['result']['chat']['id'];
            $this->m_first_name = $result['result']['from']['first_name'];
            @$this->m_username = $result['result']['from']['username'];
            $this->m_date = $result['result']['date'];
            $this->m_title = ($result['result']['chat']['type'] != 'private') ? $result['result']['chat']['title'] : null;
            return $result;
        }
        $this->m_message_id='';
    }


    function copyMessage($chat_id, $from_chat_id, $message_id, $reply_markup = null, $reply_to_message_id = null, $caption = null, $caption_entities = null, $disable_notification = null, $allow_sending_without_reply = null)
    {
        $this -> current_chat_send = $chat_id;
        $allow_sending_without_replyy = (isset($allow_sending_without_reply)) ? '&allow_sending_without_reply=' . $allow_sending_without_reply : null;
        $disable_notificationn = (isset($disable_notification)) ? '&disable_notification=' . $disable_notification : null;
        $caption_entitiess = (isset($caption_entities)) ? '&caption_entities=' . $caption_entities : null;
        $captionn = (isset($caption)) ? '&caption=' . $caption : null;
        $reply_to_message_idd = (isset($reply_to_message_id)) ? '&reply_to_message_id=' . $reply_to_message_id : null;
        $url = 'chat_id=' . $chat_id . '&from_chat_id=' . $from_chat_id . '&message_id=' . $message_id . $reply_markup . $reply_to_message_idd . $captionn . $caption_entitiess . $disable_notificationn . $allow_sending_without_replyy . '&parse_mode=html';
        $w = $this->api('copyMessage', $url);
        if ($w) {
            $result = json_decode($w, true);
            $this->m_message_id = $result['result']['message_id'];
            $this->m_message_ids['copyMessage']=$this->m_message_id;
            return $result;
        }
    }
    

    function getchat($chat_id)
    {
        $w = $this->api('getChat', "chat_id=$chat_id");
        $result = json_decode($w, true);
        if (isset($result['result'])) {
            $GLOBALS['r_bio'] = (isset($result['result']['bio'])) ? $result['result']['bio'] : null;
            $GLOBALS['r_result'] = (isset($result['result'])) ?: null;
            $GLOBALS['r_title'] = (isset($result['result']['title'])) ? $result['result']['title'] : null;
            $GLOBALS['r_description'] = (isset($result['result']['description'])) ? $result['result']['description'] : null;
            $GLOBALS['r_id'] = (isset($result['result']['id'])) ? $result['result']['id'] : null;
            $GLOBALS['r_type'] = (isset($result['result']['type'])) ? $result['result']['type'] : null;
            $GLOBALS['r_chat_username'] = (isset($result['result']['username'])) ? $result['result']['username'] : null;
            $GLOBALS['r_chat_first_name'] = (isset($result['result']['first_name'])) ? $result['result']['first_name'] : null;
            $GLOBALS['invatelink'] = (isset($result['result']['invite_link'])) ? $result['result']['invite_link'] : null;
            $GLOBALS['all_members_are_administrators'] = (isset($result['result']['all_members_are_administrators'])) ? $result['result']['all_members_are_administrators'] : null;
            //permissions
            if (isset($result['result']['permissions'])) {
                $GLOBALS['r_permissions'] = $result['result']['permissions'];
                $GLOBALS['r_can_send_messages'] = $result['result']['permissions']['can_send_messages'];
                $GLOBALS['r_can_send_media_messages'] = $result['result']['permissions']['can_send_media_messages'];
                $GLOBALS['r_can_send_polls'] = $result['result']['permissions']['can_send_polls'];
                $GLOBALS['r_can_send_other_messages'] = $result['result']['permissions']['can_send_other_messages'];
                $GLOBALS['r_can_add_web_page_previews'] = $result['result']['permissions']['can_add_web_page_previews'];
                $GLOBALS['r_can_change_info'] = $result['result']['permissions']['can_change_info'];
                $GLOBALS['r_can_invite_users'] = $result['result']['permissions']['can_invite_users'];
                $GLOBALS['r_can_pin_messages'] = $result['result']['permissions']['can_pin_messages'];
            }
            return  $result;
        } else {
            $GLOBALS['r_bio'] = null;
            $GLOBALS['r_result'] = null;
            $GLOBALS['r_title'] = null;
            $GLOBALS['r_description'] = null;
            $GLOBALS['r_id'] = null;
            $GLOBALS['r_type'] = null;
            $GLOBALS['r_chat_username'] = null;
            $GLOBALS['r_chat_first_name'] = null;
            $GLOBALS['invatelink'] = null;
            $GLOBALS['all_members_are_administrators'] = null;
            //permissions
            $GLOBALS['r_permissions'] = null;
            $GLOBALS['r_can_send_messages'] = null;
            $GLOBALS['r_can_send_media_messages'] = null;
            $GLOBALS['r_can_send_polls'] = null;
            $GLOBALS['r_can_send_other_messages'] = null;
            $GLOBALS['r_can_add_web_page_previews'] = null;
            $GLOBALS['r_can_change_info'] = null;
            $GLOBALS['r_can_invite_users'] = null;
            $GLOBALS['r_can_pin_messages'] = null;
        }
    }

    function deletemessage($chat_id, $message_id)
    {
        $this->api('deletemessage', "chat_id=$chat_id&message_id=$message_id", true);
    }
    function deletemessages($chat_id, $message_ids)
    {
        $this->api('deletemessages', "chat_id=$chat_id&message_ids=".json_encode($message_ids), true);
    }



    #answerCallbackQuery
    function answerCallbackQuery($callback_query_id, $text, $show_alert = false, $url = null)
    {
        $text = $this->replace_define($text, null, true);
        $url = ($url) ? '&url=' . $url : null;
        $this->api('answerCallbackQuery', 'callback_query_id=' . $callback_query_id . '&text=' . urlencode($text) . '&show_alert=' . $show_alert . $url);
    }

    function ReplyKeyboardRemove($chat_id, $text, $selective = false)
    {
        $removeKeyboard = array('remove_keyboard' => true, 'selective' => $selective);
        $removeKeyboardEncoded = json_encode($removeKeyboard);
        $this->api('sendmessage', 'chat_id=' . $chat_id . '&text=' . $text . '&reply_markup=' . $removeKeyboardEncoded);
    }



    function editmessagetext($text = null, $message_id, $chat_id = null, $inline_keyboard = null, $disable_web_page_preview = null,$entities=null)
    {
        $this -> current_chat_send = $chat_id;
        $text = $this->replace_define($text, $chat_id);
        $text = replace_htmltag($text);
        $disable_web_page_preview=($disable_web_page_preview || $this->disable_web_page_preview)?true:false;
        $disable_web_pagepreview = ($disable_web_page_preview) ? '&disable_web_page_preview=' . $disable_web_page_preview : null;
        $tx = ($text) ? '&text=' . urlencode($text)  : null;
        $method = ($tx) ? 'editMessageText' : 'editMessageReplyMarkup';
        $inline_keyboardd = (isset($inline_keyboard)) ? $inline_keyboard : null;
        $e = preg_match('/^([0-9]+)$/', $message_id);
        $messageid = ($e) ? '&message_id=' . $message_id : '&inline_message_id=' . $message_id;
        $chatid = (isset($chat_id)) ? 'chat_id=' . $chat_id : null;
        $entities=($entities)?"&entities=".$entities:'&parse_mode=HTML';
        $url = $chatid . $messageid . $tx . $inline_keyboardd . $disable_web_pagepreview.$entities;
        $this->api($method, $url, true);
    }

    function editMessageCaption($caption = null, $message_id = null, $chat_id = null, $inline_keyboard = null, $inline_message_id = null,$entities=null)
    {
        $this -> current_chat_send = $chat_id;
        if ($caption) {
            $caption = $this->replace_define($caption, $chat_id);
            $caption = replace_htmltag($caption);
        }
        $chatid = (isset($chat_id)) ? 'chat_id=' . $chat_id : null;
        $messageid = ($message_id) ? '&message_id=' . $message_id : null;
        $inline_messageid = ($inline_message_id) ? '&inline_message_id=' . $inline_message_id : null;
        $caption = ($caption) ? '&caption=' . urlencode(mb_substr($caption, 0, 1024, "utf8")) : null;
        $entities=($entities)?"&caption_entities=".$entities:'&parse_mode=HTML';
        $url = $chatid . $messageid . $inline_messageid . $caption . $inline_keyboard.$entities;
        $this->api('editMessageCaption', $url, true);
    }


    function editMessageReplyMarkup($message_id, $chat_id = null, $inline_keyboard = null)
    {

        $e = preg_match('/^([0-9]+)$/', $message_id);
        $messageid = ($e) ? '&message_id=' . $message_id : '&inline_message_id=' . $message_id;
        $chatid = (isset($chat_id)) ? 'chat_id=' . $chat_id : null;
        $url = $chatid . $messageid . $inline_keyboard;
        $this->api('editMessageReplyMarkup', $url, true);
    }



    function forwardmessage($chat_id, $from_chat_id, $message_id, $disable_notification = null)
    {
        $this -> current_chat_send = $chat_id;
        if (isset($disable_notification)) {
            $notification = '&disable_notification' . $disable_notification;
        } else {
            $notification = null;
        }
        $url = 'chat_id=' . $chat_id . '&from_chat_id=' . $from_chat_id . '&message_id=' . $message_id . $notification;
        $w = $this->api('forwardMessage', $url);
        $result = json_decode($w, true);
        if ($result) {
            $this->m_message_id = $result['result']['message_id'];
            $this->m_message_ids['forwardmessage']=$this->m_message_id;
            return $result;
        }
    }

    #reply_markup
    function reply_markup($ky = null, $type_ky = null, $input_field_placeholder = null, $resize_keyboard = 'true', $one_time_keyboard = 'false', $selective = 'false')
    {
        $resize_keyboard =$resize_keyboard?: 'true';
        $one_time_keyboard =$one_time_keyboard?: 'false';
        $selective = $selective?:'false';
        $pl = ($input_field_placeholder) ? ',"input_field_placeholder":"' . $input_field_placeholder . '"' : null;

        if ($type_ky == null) {
            return '&reply_markup={"remove_keyboard":true,"selective":'.$selective.'}';
        } elseif ($type_ky == 'k') {
         
            $ky=str_replace('+','\+',$ky);
            // $ky=str_replace('&','\&',$ky);
            $ky=urlencode($ky);
            return '&reply_markup={"keyboard":[' . $ky . '],"resize_keyboard":' . $resize_keyboard . ',"selective":' . $selective . ',"one_time_keyboard":' . $one_time_keyboard . $pl . '}';
        } elseif ($type_ky == 'f') {
            $mark = ["force_reply" => true, "input_field_placeholder" => "$input_field_placeholder"];
            $mark = ($selective) ? array_merge($mark, ["selective" => $selective]) : $mark;
            return '&reply_markup=' . json_encode($mark);
        } else {
            return '&reply_markup={"inline_keyboard":[' . urlencode($ky) . ']}';
        }
    }
    #edit media
    function editMessageMedia($media, $chat_id = null, $message_id = null, $inline_message_id = null, $reply_markup = null)
    {
        $inlinemessageid = ($inline_message_id) ? '&inline_message_id=' . $inline_message_id : null;
        $url = 'chat_id=' . $chat_id . '&message_id=' . $message_id . $inlinemessageid . '&media=' . $media . $reply_markup;
        $this->api('editMessageMedia', $url, true);
    }
    #media
    function sendmedia($type, $file, $chat_id, $caption = null, $reply_markup = null, $reply_to_message_id = null, $content = null,$entities=null,$protect=null)
    {
        $this -> current_chat_send = $chat_id;
        $w_b_w = null;
        
        if ($caption) {
            $caption = $this->replace_define($caption, $chat_id);
            $txt = $caption;
            $wbw = 'caption';

            $caption = replace_htmltag($caption);
            $caption = urlencode($caption);
        }

        #edit
        if (is_array($type)) {
            $type1 = $type[0];
            $message_id = $type[1];
            if ($type1 == 'text') {
                $this->editmessagetext(urldecode($file), $message_id, $chat_id, $reply_markup,null,$entities);
            } else {
                $cap = ',"caption":"' . $caption . '"';
                $media = ($entities)?'{"caption_entities":'.$entities.',"type":"' . $type1 . '","media":"' . $file . '"' . $cap . '}'
                                    :'{"parse_mode":"HTML","type":"' . $type1 . '","media":"' . $file . '"' . $cap . '}';
                $this->editMessageMedia($media, $chat_id, $message_id, null, $reply_markup);
            }
        } else {
            if ($caption) {
                $sdrpk = (isset($GLOBALS['rpkey_o'])) ? $GLOBALS['rpkey_o'] : null;
                if ($sdrpk and $w_b_w) {
                    $caption = urlencode($GLOBALS['text']);
                    $rrpn = null;
                    $this->sendmessage($chat_id, $GLOBALS['text'], $reply_markup);
                } else {
                    $caption = ($w_b_w) ? substr($caption, 0, 1) : $caption;
                }
            }
            
            $method = $this ->get_method_from_type($type);
            if ($type == 'text') {
                $file = $this->replace_define($file, $chat_id);
                $txt = $file;
                $wbw = 'text';
                $file = replace_htmltag($file);
                if (!$file) {
                    return false;
                }
                $file = urlencode($file);
                $rp_key_o = (isset($GLOBALS['rpkey_o'])) ? $GLOBALS['rpkey_o'] : null;
                if ($rp_key_o and $w_b_w) {
                    $file = urlencode($GLOBALS['text']);
                    $rrpn = null;
                    $this->sendmessage($chat_id, $GLOBALS['text'], $reply_markup);
                } else {
                    $file = ($w_b_w) ? substr($file, 0, 1) : $file;
                }
            }
            
            if($this->plus_keyboard) {
                if($reply_markup) {
                    $reply_markup=substr($reply_markup,0,-2).urlencode(','.$this->plus_keyboard). ']}';
                } else {
                    $reply_markup=$this->reply_markup($this->plus_keyboard,'i');
                }
                $this->plus_keyboard='';
            }
            if($this->add_inline_key){
                if($reply_markup) {
                    $reply_markup=substr($reply_markup,0,-2).urlencode(','.implode(',',$this->add_inline_key)). ']}';
                } else {
                    $reply_markup=$this->reply_markup(implode(',',$this->add_inline_key),'i');
                }
                $this->add_inline_key=[];
            }
            if($this-> chat_id_changed) {
                $chat_id=$this-> chat_id_changed;
                $this-> chat_id_changed=null;
            }
            $caption = ($caption) ? '&caption=' . $caption : null;
            $reply_to_message = ($reply_to_message_id) ? '&reply_to_message_id=' . $reply_to_message_id : null;
            $disable_web_page_preview=($this->disable_web_page_preview)?"&disable_web_page_preview=".true:null;
            $entities_mode=($caption)?'caption_entities':'entities';
            $parse_mode=($entities && !$this->no_entities)?"&$entities_mode=".$entities:'&parse_mode=html';
            $url = 'chat_id=' . $chat_id . '&' . $type . '=' . $file . $caption . $reply_markup . $reply_to_message . $content .$disable_web_page_preview. $parse_mode.$protect;
            $w = (!$w_b_w) ? $this->api($method, $url) : null;
        }

        if (@$w) {
            $result = json_decode($w, true);
            $this->m_message_id = $result['result']['message_id'];
            $this->m_message_ids['sendmedia']=$this->m_message_id;
            @$this->m_userid = $result['result']['from']['id'];
            @$this->m_is_bot = $result['result']['from']['is_bot'];
            $this->m_text = (isset($result['result']['text'])) ? $result['result']['text'] : null;
            $this->m_type = $result['result']['chat']['type'];
            $this->m_chat_id = $result['result']['chat']['id'];
            @$this->m_first_name = $result['result']['from']['first_name'];
            @$this->m_username = $result['result']['from']['username'];
            $this->m_date = $result['result']['date'];
            $this->m_title = ($result['result']['chat']['type'] != 'private') ? $result['result']['chat']['title'] : null;
        }
        if (@$w) {
            return true;
        }
        $this->m_message_id='';
    }


    #answerInlineQuery
    function answerInlineQuery($inline_query_id, $results, $cache_time = null, $is_personal = null, $next_offset = null)
    {
        $cache_time = (isset($cache_time)) ? '&cache_time=' . $cache_time : null;
        $next_offset = (isset($next_offset)) ? '&next_offset=' . $next_offset : null;
        $is_personal = (isset($is_personal)) ? '&is_personal=' . $is_personal : null;
        $url = 'inline_query_id=' . $inline_query_id . '&results=' . json_encode($results) . $cache_time . $next_offset . $is_personal;
        $this->api('answerInlineQuery', $url);
    }

    
} 
